// UsccOcxView.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "UsccView.h"
#include "UsccOcxView.h"
#include "MainFrm.h"
#include "TextInputDlg.h"

// ATL is only included inline, no link-time import is used.
#include "atlhost.h"
static CComModule _AtlModule;

// CUsccOcxView


IMPLEMENT_DYNAMIC(CUsccOcxView, CWnd)

const CLSID& CUsccOcxView::GetClsid()
{
    static const CLSID clsid = { 0x995802AB, 0xB96E, 0x4F3D, { 0x90, 0x8E, 0x61, 0x2F, 0x1D, 0xD4, 0xBD, 0x85 } };

    return clsid;
}


CUsccOcxView::CUsccOcxView()
    : m_pDispatchUsccOcxClass(NULL)
{

}

CUsccOcxView::~CUsccOcxView()
{
    if(m_pDispatchUsccOcxClass) {
        m_pDispatchUsccOcxClass->Release();
    }
}


BEGIN_MESSAGE_MAP(CUsccOcxView, CWnd)
    ON_WM_CREATE()
    ON_COMMAND(ID_USCC_OCX_PATH, OnUsccOcxPath)
    ON_COMMAND_RANGE(ID_SHOWPAGE_1, ID_SHOWPAGE_20, OnShowpage)
    ON_COMMAND(ID_SELECTLANGUAGE, OnSelectlanguage)
    ON_COMMAND(ID_APPLICATIONSCOPE, &CUsccOcxView::OnApplicationscope)
END_MESSAGE_MAP()


// CUsccOcxView-Meldungshandler

int CUsccOcxView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    HRESULT hr;
    IUnknown* punkControl = NULL;

    if (CWnd::OnCreate(lpCreateStruct) == -1)
        return -1;

    hr = CoCreateInstance(GetClsid(), NULL, CLSCTX_INPROC_SERVER, IID_IUnknown, (LPVOID*)&punkControl);

    if(FAILED(hr)) {
        return -1;
    }

    hr = SafeQueryInterface(punkControl, &m_pDispatchUsccOcxClass);

    if(FAILED(hr)) {

        SafeRelease(&punkControl);
        return -1;
    }

    hr = ATL::AtlAxAttachControl(punkControl, m_hWnd, NULL);
    SafeRelease(&punkControl);

    if(FAILED(hr)) {
        return -1;
    }

    return InitControl();
}


HWND CUsccOcxView::GetControlsWindow()
{
    HRESULT hr;
    HWND hWndChild = NULL;
    IOleWindow* p_owChild = NULL;

    hr = SafeQueryInterface(m_pDispatchUsccOcxClass, &p_owChild);

    if(SUCCEEDED(hr)) {

        p_owChild->GetWindow(&hWndChild);
        SafeRelease(&p_owChild);
    }

    return hWndChild;
}


int CUsccOcxView::InitControl()
{
    HWND hWndChild = GetControlsWindow();

    if(!hWndChild) {

        SafeRelease(&m_pDispatchUsccOcxClass);
        return -1;
    }

    EnableActiveX(1);

    // Init rect to any valid rect; own client rect is at this time still empty
    // Resize will be done through main frame after its own creation completion
    CRect rctInit(0, 0, 10, 10);
    ::SetWindowPos(hWndChild,
        m_hWnd,
        rctInit.left,
        rctInit.top,
        rctInit.Width(),
        rctInit.Height(),
        SWP_SHOWWINDOW);

    ::BringWindowToTop(hWndChild);
    ::SetFocus(hWndChild);

    SetStatusText();

    return 0;
}


void CUsccOcxView::SetStatusText(LPCTSTR pszText)
{
    CMainFrame* pFrame = (CMainFrame*)GetParent();

    if(pFrame) {

        CString strMessageText;

        if(!pszText) {

            strMessageText = applicationScope();

            if(!strMessageText.IsEmpty()) {
                strMessageText += _T(": ");
            }

            strMessageText += usccOcxPath();
            strMessageText.Replace('/', '\\');
        }
        else {
            strMessageText = pszText;
        }

        pFrame->StatusBarIdleMessage(strMessageText);
    }
}


void CUsccOcxView::OnUsccOcxPath()
{
    CString strPath;
    BROWSEINFO bi = { 0 };
    TCHAR chPathBuffer[MAX_PATH + 1] = { 0 };
    HWND hWndChild = GetControlsWindow();

    bi.hwndOwner = m_hWnd;
    bi.pszDisplayName = chPathBuffer;
    bi.lpszTitle = _T("Select a new usccOcxPath!");
    bi.ulFlags = BIF_RETURNONLYFSDIRS|BIF_USENEWUI;

    PIDLIST_ABSOLUTE pidlFolder = SHBrowseForFolder(&bi);

    if(!pidlFolder)
        return;

    if(lstrlen(bi.pszDisplayName) > 0) {

        SetStatusText(_T(""));
        GetParent()->UpdateWindow();

        // Force resize of UsccOcx control
        CRect rctParent;
        GetParent()->GetWindowRect(rctParent);
        rctParent.right--;

        CWaitCursor cw;

        TCHAR chNewPathBuffer[MAX_PATH + 1] = { 0 };

        SHGetPathFromIDList(pidlFolder, chNewPathBuffer);

        strPath = chNewPathBuffer;
        strPath.Replace('\\', '/');

        GetParent()->MoveWindow(rctParent, FALSE);
        rctParent.right++;

        EnableActiveX(0);
        setUsccOcxPath(strPath);
        EnableActiveX(1);

        SetStatusText();

        // Force resize of UsccOcx control
        GetParent()->MoveWindow(rctParent, TRUE);
    }
}


void CUsccOcxView::OnShowpage(UINT id)
{
    // Force resize of UsccOcx control
    CRect rctParent;
    GetParent()->GetWindowRect(rctParent);
    rctParent.right--;

    GetParent()->MoveWindow(rctParent, FALSE);
    rctParent.right++;

    ShowPage((LONG)(id - ID_SHOWPAGE_1 + 1), 0);

    // Force resize of UsccOcx control
    GetParent()->MoveWindow(rctParent, TRUE);
}



void CUsccOcxView::OnSelectlanguage()
{
    CTextInputDlg dlg;
    dlg.m_strTitle.LoadString(IDS_LANGUAGE_LOCALE);

    if(dlg.DoModal() != IDOK) {
        return;
    }

    SelectLanguage(dlg.m_strInput);
}


void CUsccOcxView::OnApplicationscope()
{
    CTextInputDlg dlg;
    dlg.m_strTitle = _T("Application Scope");

    if(dlg.DoModal() != IDOK) {
        return;
    }

    SetStatusText(_T(""));
    GetParent()->UpdateWindow();

    // Force resize of UsccOcx control
    CRect rctParent;
    GetParent()->GetWindowRect(rctParent);
    rctParent.right--;

    GetParent()->MoveWindow(rctParent, FALSE);
    rctParent.right++;

    EnableActiveX(0);
    setApplicationScope(dlg.m_strInput);
    EnableActiveX(1);

    SetStatusText();

    // Force resize of UsccOcx control
    GetParent()->MoveWindow(rctParent, TRUE);
}



//////////////////////////////////////////////////////////////////////////////////////
// UsccOcx Control
// Properties
int CUsccOcxView::GetApiVersion()
{
    HRESULT hr;

    if(!m_pDispatchUsccOcxClass) {
        return 0;
    }

    COleVariant varRet;
    DISPPARAMS dispparams = {NULL, NULL, 0, 0};

    hr = m_pDispatchUsccOcxClass->Invoke(1, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYGET, &dispparams, varRet, NULL, NULL);

    if(SUCCEEDED(hr)) {
        return (int)varRet.lVal;
    }

    return 0;
}


CString CUsccOcxView::GetBuildDate()
{
    HRESULT hr;
    CString result;

    if(!m_pDispatchUsccOcxClass) {
        return result;
    }

    COleVariant varRet;
    DISPPARAMS dispparams = {NULL, NULL, 0, 0};

    hr = m_pDispatchUsccOcxClass->Invoke(2, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYGET, &dispparams, varRet, NULL, NULL);

    if(SUCCEEDED(hr)) {
        result = varRet.bstrVal;
    }

    return result;
}


int CUsccOcxView::GetBuildNumber()
{
    HRESULT hr;

    if(!m_pDispatchUsccOcxClass) {
        return 0;
    }

    COleVariant varRet;
    DISPPARAMS dispparams = {NULL, NULL, 0, 0};

    hr = m_pDispatchUsccOcxClass->Invoke(3, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYGET, &dispparams, varRet, NULL, NULL);

    if(SUCCEEDED(hr)) {
        return (int)varRet.lVal;
    }

    return 0;
}


CString CUsccOcxView::GetVersion()
{
    HRESULT hr;
    CString result;

    if(!m_pDispatchUsccOcxClass) {
        return result;
    }

    COleVariant varRet;
    DISPPARAMS dispparams = {NULL, NULL, 0, 0};

    hr = m_pDispatchUsccOcxClass->Invoke(4, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYGET, &dispparams, varRet, NULL, NULL);

    if(SUCCEEDED(hr)) {
        result = varRet.bstrVal;
    }

    return result;
}


// Methods
LONG CUsccOcxView::EnableActiveX(LONG mode)
{
    HRESULT hr;

    if(!m_pDispatchUsccOcxClass) {
        return 0;
    }

    COleVariant varIn(mode);
    COleVariant varRet;
    DISPPARAMS dispparams = {varIn, NULL, 1, 0};

    hr = m_pDispatchUsccOcxClass->Invoke(5, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &dispparams, varRet, NULL, NULL);

    if(SUCCEEDED(hr)) {
        return varRet.lVal;
    }

    return 0;
}


LONG CUsccOcxView::ShowPage(LONG page, LONG securityLevel)
{
    HRESULT hr;

    if(!m_pDispatchUsccOcxClass) {
        return 0;
    }

    COleVariant varIn[2];
    COleVariant varRet;
    DISPPARAMS dispparams = { varIn, NULL, 2, 0};

    // Insert params in backward order
    varIn[0] = securityLevel;
    varIn[1] = page;

    hr = m_pDispatchUsccOcxClass->Invoke(6, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &dispparams, varRet, NULL, NULL);

    if(SUCCEEDED(hr)) {
        return varRet.lVal;
    }

    return 0;
}


LONG CUsccOcxView::SelectLanguage(LPCTSTR locale)
{
    HRESULT hr;

    if(!m_pDispatchUsccOcxClass) {
        return 0;
    }

    COleVariant varIn(locale);
    COleVariant varRet;
    DISPPARAMS dispparams = {varIn, NULL, 1, 0};

    hr = m_pDispatchUsccOcxClass->Invoke(7, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &dispparams, varRet, NULL, NULL);

    if(SUCCEEDED(hr)) {
        return varRet.lVal;
    }

    return 0;
}


CString CUsccOcxView::usccOcxPath()
{
    HRESULT hr;
    CString result;

    if(!m_pDispatchUsccOcxClass) {
        return result;
    }

    COleVariant varRet;
    DISPPARAMS dispparams = {NULL, NULL, 0, 0};

    hr = m_pDispatchUsccOcxClass->Invoke(8, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &dispparams, varRet, NULL, NULL);

    if(SUCCEEDED(hr)) {
        result = varRet.bstrVal;
    }

    return result;
}


LONG CUsccOcxView::setUsccOcxPath(LPCTSTR path)
{
    HRESULT hr;

    if(!m_pDispatchUsccOcxClass) {
        return 0;
    }

    COleVariant varIn(path);
    COleVariant varRet;
    DISPPARAMS dispparams = {varIn, NULL, 1, 0};

    hr = m_pDispatchUsccOcxClass->Invoke(9, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &dispparams, varRet, NULL, NULL);

    if(SUCCEEDED(hr)) {
        return varRet.lVal;
    }

    return 0;
}


CString CUsccOcxView::applicationScope()
{
    HRESULT hr;
    CString result;

    if(!m_pDispatchUsccOcxClass) {
        return result;
    }

    COleVariant varRet;
    DISPPARAMS dispparams = {NULL, NULL, 0, 0};

    hr = m_pDispatchUsccOcxClass->Invoke(10, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &dispparams, varRet, NULL, NULL);

    if(SUCCEEDED(hr)) {
        result = varRet.bstrVal;
    }

    return result;
}


LONG CUsccOcxView::setApplicationScope(LPCTSTR scope)
{
    HRESULT hr;

    if(!m_pDispatchUsccOcxClass) {
        return 0;
    }

    COleVariant varIn(scope);
    COleVariant varRet;
    DISPPARAMS dispparams = {varIn, NULL, 1, 0};

    hr = m_pDispatchUsccOcxClass->Invoke(11, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &dispparams, varRet, NULL, NULL);

    if(SUCCEEDED(hr)) {
        return varRet.lVal;
    }

    return 0;
}
